<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Funnel Chart with Custom Neck</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array( 
        array("label"=>"Total CV's", "y"=>1398),
        array("label"=>"Prospects", "y"=>895),
        array("label"=>"Aptitude Test", "y"=>200),
        array("label"=>"Interviews", "y"=>50),
        array("label"=>"New Hires", "y"=>11)
    )
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            title: {
                text: "Recruitment Process"
            },
            data: [{
                type: "funnel",
                indexLabel: "{label} - {y}",
                yValueFormatString: "#,##0",
                neckHeight: 0,
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>